<?php 
$naziv = 'Početna strana';
?>
<?php require_once("../resources/config.php"); ?>
<!DOCTYPE html>
<html lang="sr">

<?php include(TEMPLATE_FRONT . DS . "head.php"); ?>
    
<body>
    
<span class="loader"></span>
<header>
    <?php include(TEMPLATE_FRONT . DS . "header.php");?>   
</header>

    <?php include(TEMPLATE_FRONT . DS . "slider.php");?>      
    
    <?php include(TEMPLATE_FRONT . DS . "uvodnaPodela.php");?>  
    

<section>
  <div class="container">
      <div class="row">
        <div class="col-xl-6">
          <div class="party-balloons">
            <h2>Baloni za sve prilike</h2>
            <p>svaki vaš povod je naša radost</p>
            <ul>
              <li><img alt="chak" src="assets/img/chak.png">Wide Selection Of Foil Balloons</li>
              <li><img alt="chak" src="assets/img/chak.png">Latex Balloons For Valentine's Day</li>
              <li><img alt="chak" src="assets/img/chak.png">Best Options In Balloons Themes</li>
            </ul>
            <div class="call-us">
              <img alt="call" src="assets/img/call.png">
              <div>
                <span>Have Questions? Call Us</span>
                <a href="callto:+02101283492">+021 01283492</a>
                <p>Open monday to Friday 9:30 AM to 6:00 PM</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-6">
          <div class="party-balloon-img">
            <img alt="party-balloon" class="p-balloon" src="https://via.placeholder.com/360x360">
            <img alt="party-balloon" src="https://via.placeholder.com/546x546">
            <div class="b-shap"></div>
          </div>
        </div>
      </div>
      <div class="row gap">
        <div class="col-lg-4 col-md-6">
          <div class="we-provide">
            <i>
              <svg height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g fill="rgb(0,0,0)"><path d="m31.75452 16.74432a1.19223 1.19223 0 0 0 -1.16877 1.02985c-12.514.102-17.71691 16.48578-7.81274 24.03961 4.6283 3.37836 12.12848 3.51471 17.0329.63837 4.59118-2.93573 7.05511-9.75379 6.30054-15.02405-1.00464-7.0166-7.78254-10.53644-14.35193-10.68378zm8.277 22.1283c-3.4386 3.61871-9.97846 4.46954-14.40021 2.32526-10.57443-5.88588-6.39504-21.25122 5.33169-22.23407 4.51148 1.09 10.59607 2.01422 12.23944 7.25659 1.29249 4.03076-.35454 9.59448-3.17088 12.65222z"/><path d="m59.35413 25.232a2.67286 2.67286 0 0 0 -2.25354-.51226 9.6108 9.6108 0 0 0 -.68964-3.4751c-.55634-1.24243-2.42554-2.82807-3.68475-1.70783a.854.854 0 0 0 -.147-.0783c.49225-7.01587-8.458-12.68958-14.46521-14.20673-10.86466-3.01887-23.84568 3.13463-27.44468 13.98314-2.853-.316-3.77 3.19074-3.70953 5.49762-6.20551-.68286-7.12268 12.81568-.34052 12.037.0907 2.71124 1.43311 6.31256 4.56348 6.498a9.45778 9.45778 0 0 0 7.10284 8.69067 4.3963 4.3963 0 0 0 7.46979 2.23c1.96509-1.87561 1.80921-5.71954-1.017-6.66107-.87811-.27429-2.09533-.5498-2.85284.10858a.8224.8224 0 0 0 -.81818-.20892 4.24966 4.24966 0 0 0 -2.45257 2.16876 8.381 8.381 0 0 1 -5.483-6.86749c4.37481-2.94607 3.00732-9.21837 3.35559-13.76007.16186-3.36328.1889-9.26386-4.19-9.66815a23.303 23.303 0 0 1 10.98943-10.82017c.9809 2.87854 4.85852 2.57019 7.34418 2.595 2.31915-.11866 9.74713-.008 10.4281-2.61328 4.55042 2.13287 9.23841 5.75427 10.46271 10.84033-3.48773.3919-4.157 4.94049-4.04193 7.828.27795 4.31451-.47833 8.91754 1.13043 13.02 3.18414 6.13452 8.7721 2.303 8.75867-3.38245 5.91028.52372 5.96283-8.99995 1.98517-11.53528zm-52.75037 9.5122c-3.25407-.21088-3.20334-4.7661-1.91409-6.92028a3.32956 3.32956 0 0 1 1.61819-1.5138 1.139 1.139 0 0 0 .51044-.315.45518.45518 0 0 0 .10931-.01512c-.09961 2.92332-.22784 5.84-.32385 8.7642zm15.31604 14.1788c.73547.62983 2.13715.18915 2.79974.8172 1.50223 2.32754-1.7061 4.734-3.5308 3.27463a2.36067 2.36067 0 0 1 .73106-4.09183zm-7.75116-18.04116c-.12836 2.7741.77722 9.36865-2.73309 10.23565-1.67066.18305-2.41577-2.22033-2.61469-3.4834-.40857-4.19458.06018-8.47174-.01776-12.69256.02594-1.67475.01392-4.23767 2.24652-4.13446a.79556.79556 0 0 0 .38922.24652c3.69593 1.03253 2.74416 7.03094 2.7298 9.82825zm24.46636-22.74573c-3.1629 1.96985-6.96588 1.59253-10.507 1.26074-1.24615-.14075-2.72626-.29126-3.44372-1.5094a21.34442 21.34442 0 0 1 14.61172-.12427c-.20683.11109-.41532.23853-.661.37293zm16.54413 29.498c-.90412 5.33338-4.71356 4.08167-5.19525-.60492a49.49947 49.49947 0 0 1 -.15247-6.14733c-.01434-2.79621-.96545-8.7959 2.7298-9.82825a.795.795 0 0 0 .389-.24652c2.233-.10333 2.22082 2.46387 2.24646 4.13446-.07767 4.22074.39122 8.49839-.01753 12.69254zm4.09155-3.78344a2.30717 2.30717 0 0 1 -1.87958.88916c-.03344-2.93647-.27978-5.79822-.26172-8.74762 2.92494 1.11466 3.90541 5.37492 2.14131 7.85844z"/><path d="m36.0592 35.28558a6.02411 6.02411 0 0 1 -6.71038 1.6745c-.76038-.41821-1.53778-.7962-2.32337-1.15857-1.121-.28936-.15967 1.54737.16327 1.90589a6.59968 6.59968 0 0 0 7.96021.94665 6.322 6.322 0 0 0 2.26617-2.57586.78582.78582 0 0 0 -1.3559-.79261z"/><path d="m34.31537 49.10419a.79326.79326 0 0 0 -.73462-.55927c-.79028-.26526-6.25073 1.38812-4.294 2.46991.97564.27362 5.424-.45083 5.02862-1.91064z"/><path d="m34.07129 53.60315a13.59336 13.59336 0 0 0 -4.19849-.49939.87182.87182 0 0 0 -.23047 1.70343c1.33844.18152 3.09223.69763 4.429.36859a.82167.82167 0 0 0 -.00004-1.57263z"/><path d="m30.43817 57.13177c-.77832-.352-1.31518-1.22729-2.17578-1.33343a1.08619 1.08619 0 0 0 -.76239 1.84066 4.6034 4.6034 0 0 0 2.90991 1.86834c1.78717-.11769 1.15686-1.7588.02826-2.37557z"/></g></svg>
            </i>
            <div>
              <h4>Support 24/7</h4>
              <span>Contact us 24 hours a day, 7 days a week</span>
            </div>
          </div>
        </div>
        <div class="col-lg-4 col-md-6">
          <div class="we-provide">
            <i>
              <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                 viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512.001 512.001;" xml:space="preserve">
                    <path d="M76.776,277.958c12.542-3.531,25.023-7.27,37.448-11.189c24.507-7.728,48.79-16.154,72.896-25.047
                      c52.903-19.517,104.956-41.294,156.67-63.75c1.395,5.216,2.889,10.396,4.741,15.409c3.085,8.348,10.204,15.733,19.92,13.438
                      c10.313-2.435,16.884-14.034,23.26-21.567c7.579-8.953,15.263-17.798,22.96-26.649c7.682-8.834,15.375-17.659,23.073-26.479
                      c7.573-8.677,16.061-17.159,22.792-26.502c6.416-8.906,3.581-18.509-3.357-26.101c-6.892-7.543-14.674-14.444-22.624-20.843
                      c-16.365-13.171-34.002-24.618-52.62-34.34c-9.163-4.784-18.535-9.144-28.052-13.174c-9.161-3.879-18.801-8.581-28.581-10.612
                      c-9.756-2.025-20.39,1.417-23.567,11.698c-1.626,5.263-0.479,10.709,0.605,15.959c1.265,6.126,2.651,12.229,4.129,18.307
                      c2.112,8.684,4.448,17.312,6.971,25.884c-50.848,12.518-100.737,29.209-150.404,45.708
                      c-25.057,8.323-50.059,16.812-75.003,25.467c-12.648,4.388-25.246,8.903-37.829,13.473c-9.806,3.562-19.789,7.139-28.335,13.28
                      c-8.377,6.019-14.769,14.447-16.525,24.797c-1.835,10.802,0.255,22.423,3.482,32.761c3.62,11.598,8.27,22.984,14.006,33.697
                      c4.617,8.624,9.879,18.069,19.91,21.069C53.79,285.957,66.213,280.933,76.776,277.958z M319.084,16.263
                      c7.689,1.109,15.192,4.634,22.363,7.486c39.584,15.736,73.002,38.618,104.938,66.398c1.891,1.645,3.946,3.65,3.837,6.154
                      c-0.074,1.71-1.166,3.185-2.213,4.539c-24.056,31.073-47.615,64.486-77.603,90.236c-1.424,1.223-3.232,2.503-5.019,1.926
                      c-1.624-0.525-2.397-2.332-2.969-3.941c-4.334-12.184-8.574-24.414-12.496-36.737c-7.012-21.928-13.894-43.912-20.584-65.94
                      c-4.511-14.856-8.295-29.971-11.879-45.114c-0.506-2.725-0.998-5.453-1.465-8.185c-0.746-4.367-1.964-9.079-1.939-13.529
                      C314.078,15.588,315.602,15.76,319.084,16.263z M42.888,271.742c-1.453-0.691-2.742-1.627-3.908-2.718
                      c-2.155-2.02-3.886-4.574-5.447-7.112c-7.276-11.827-12.632-24.834-15.795-38.355c-2.211-9.457-3.226-19.915,1.428-28.441
                      c5.394-9.881,16.816-14.536,27.366-18.462c37.716-14.033,75.388-28.173,113.264-41.758
                      c51.898-18.614,104.113-36.25,155.822-55.398c9.018,27.47,17.048,55.263,24.072,83.309
                      c-91.237,39.803-182.751,79.708-278.149,108.121C55.432,272.748,48.645,274.478,42.888,271.742z"/>
                    <path d="M503.173,284.113c-3.62-11.598-8.27-22.984-14.006-33.697c-4.617-8.624-9.879-18.069-19.91-21.069
                      c-11.046-3.303-23.468,1.721-34.03,4.696c-12.542,3.531-25.023,7.27-37.448,11.189c-24.507,7.728-48.79,16.154-72.896,25.047
                      c-52.903,19.517-104.956,41.294-156.67,63.75c-1.395-5.216-2.889-10.396-4.741-15.409c-3.085-8.348-10.204-15.733-19.92-13.438
                      c-10.313,2.435-16.884,14.034-23.26,21.567c-7.579,8.953-15.263,17.798-22.96,26.649c-7.682,8.834-15.375,17.658-23.073,26.479
                      c-7.573,8.677-16.061,17.16-22.792,26.502c-6.416,8.906-3.581,18.509,3.357,26.101c6.892,7.543,14.674,14.444,22.624,20.843
                      c16.365,13.171,34.002,24.618,52.62,34.34c9.163,4.784,18.535,9.144,28.052,13.174c9.161,3.879,18.801,8.581,28.581,10.612
                      c9.756,2.025,20.39-1.417,23.567-11.698c1.626-5.263,0.479-10.709-0.605-15.959c-1.266-6.126-2.651-12.229-4.129-18.307
                      c-2.112-8.684-4.448-17.312-6.971-25.884c50.848-12.518,100.737-29.209,150.404-45.708c25.057-8.323,50.059-16.812,75.003-25.467
                      c12.648-4.388,25.246-8.903,37.829-13.473c9.806-3.562,19.789-7.139,28.335-13.28c8.377-6.019,14.769-14.447,16.525-24.797
                      C508.489,306.072,506.4,294.451,503.173,284.113z M196.529,495.731c-1.087,0.65-2.389,0.571-3.656,0.281
                      c-0.471-0.108-0.938-0.245-1.387-0.386c-47.29-14.753-91.086-40.585-126.874-74.837c-1.108-1.062-2.262-2.22-2.595-3.719
                      c-0.495-2.228,0.957-4.378,2.337-6.196c22.939-30.238,46.905-61.693,74.631-87.734c2.099-1.973,5.501-5.609,8.357-3.656
                      c2.451,1.674,3.812,8.031,4.693,10.527c18.256,51.779,35.674,104.789,46.007,158.79
                      C198.517,491.284,198.698,494.435,196.529,495.731z M495.788,304.454c-0.214,4.481-1.176,8.839-3.3,12.803
                      c-4.496,8.39-13.403,13.47-22.352,16.721c-20.112,7.305-40.397,14.21-60.567,21.437c-33.25,11.912-66.5,23.825-99.75,35.737
                      c-36.878,13.213-75.082,24.793-111.036,40.417c-0.143,0.062-2.379,0.878-2.318,1.071c-2.967-9.635-6.174-19.196-9.623-28.671
                      c-4.348-17.701-9.045-35.295-14.076-52.832c-0.202-0.705-0.395-1.418-0.591-2.127c0.018-0.007,0.036-0.013,0.054-0.021
                      c49.821-21.298,99.672-42.551,150.058-62.487c25.196-9.969,50.526-19.611,76.036-28.752c11.564-4.144,23.18-7.99,34.865-11.715
                      c10.428-3.326,21.996-10.289,33.194-6.272c7.652,2.744,12.61,10.082,16.335,17.306c5.1,9.89,8.925,20.436,11.35,31.296
                      C495.236,293.596,496.044,299.112,495.788,304.454z"/>
              </svg>
            </i>
            <div>
              <h4>8 Days Exchange</h4>
              <span>Exchange within 6 to 8 working days.</span>
            </div>
          </div>
        </div>
        <div class="col-lg-4 col-md-6">
          <div class="we-provide mb-0">
            <i>
              <svg xmlns="http://www.w3.org/2000/svg" height="512" viewBox="0 0 64 64" width="512"><g fill="rgb(0,0,0)"><path d="m53.192 31.59766a14.82091 14.82091 0 0 0 -2.88532.309.87337.87337 0 0 0 -.63666.83618.88262.88262 0 0 0 .63666.83624 14.86968 14.86968 0 0 0 2.88532.309c2.4377.21348 2.43977-2.50521 0-2.29042z"/><path d="m3.1059 18.44952c5.70275.6695 11.494 1.07947 17.20514 1.37488a9.40607 9.40607 0 0 0 -1.47704 3.19495c-3.52728.16443-7.13256-.12573-10.60424.58386a.68477.68477 0 0 0 0 1.311c3.39831.649 6.89935.26825 10.34436.39276a10.64089 10.64089 0 1 0 19.49212-5.6388c-2.79415-4.1274-9.35224-6.2228-13.5544-2.94117a7.868 7.868 0 0 0 -3.27936 2.00519c-.30725-.87946-1.32318-.87134-2.12256-.95q-3.396-.32392-6.80169-.5315a61.3992 61.3992 0 0 0 -9.20233.21442.49252.49252 0 0 0 0 .98441zm21.98327.20048c.61066.15424 1.228-.23724 1.83045-.31964.62811-.095 1.72717.44867 2.05987-.30542a7.56061 7.56061 0 0 1 6.93305 11.32184c-4.01032 6.67951-13.78009 4.475-15.03473-3.06317a7.08307 7.08307 0 0 1 4.21136-7.63361z"/><path d="m11.19812 30.2915c-2.24127.27161-4.50763.20765-6.76013.34894-.8728.05481-1.2038 1.48541-.22119 1.63434a31.24751 31.24751 0 0 0 3.40936.45758 26.30667 26.30667 0 0 0 3.44019-.07715c2.31262-.2102 4.63293.10144 6.94506-.08563 1.559-.12616 1.58521-2.55981 0-2.45453-2.26922.15076-4.55169-.09765-6.81329.17645z"/><path d="m24.52844 28.70752a1.14747 1.14747 0 0 0 .91748-.08441c.62781-.09357 1.23908-.13941 1.8664-.21259a3.61974 3.61974 0 0 0 1.34468-.25012 1.39482 1.39482 0 0 0 .69489-1.24219 42.59241 42.59241 0 0 0 -.29889-5.34491.85784.85784 0 0 0 -.83209-.832.84451.84451 0 0 0 -.832.832 40.37033 40.37033 0 0 0 .17481 5.06617c-.74188.05218-1.53882.13476-2.27136.14752a1.23043 1.23043 0 0 0 -.999.1214.99633.99633 0 0 0 .23508 1.79913z"/><path d="m61.2132 40.3996a4.07218 4.07218 0 0 0 -2.428-2.436.95152.95152 0 0 0 .9165-.90228c.12891-1.83466.03894-3.68164.11768-5.51868a34.66656 34.66656 0 0 0 .23114-5.27478c-.144-2.22412-2.1778-3.10162-3.81635-4.14734-.64538-.50543-1.16058-1.158-1.77258-1.70123-2.36509-2.09965-5.40391-1.86129-8.31059-1.31938a7.718 7.718 0 0 0 -3.04571 1.05988c-.575-3.74164 1.55328-10.41064-3.976-10.902a32.34238 32.34238 0 0 0 -6.05633-.19452 134.16572 134.16572 0 0 1 -22.59082-.8952c-4.69308-.94523-5.43179 2.71793-4.02676 6.34273a1.40028 1.40028 0 1 0 2.57019-1.08368 7.315 7.315 0 0 1 -.50592-2.70251c.22931-.25641 1.23865-.12335 1.50348-.11255a99.25531 99.25531 0 0 0 16.30963.46021c2.175-.05616 4.3357-.26362 6.5044-.42865 2.42389-.00934 8.28168-1.54938 8.42468 2.12677.31879 3.3966-.36139 6.77349-.387 10.15087a1.01441 1.01441 0 0 0 .47149.8028c-.22607 4.59711-.47668 9.21777-.45343 13.81311-10.92358-.00177-21.81646 1.06952-32.73364.80811.40863-.45649.24292-1.10468.34931-1.66163l-.04126.307c-.00037-.70727.44867-1.46112.09442-2.12781a1.11229 1.11229 0 0 0 -1.50818-.39544 1.2333 1.2333 0 0 0 -.50653.65875 4.97 4.97 0 0 0 -.253 2.87671c-5.24067 1.92535-4.08893 7.618 1.339 7.96838-1.15686 2.53485.00775 6.03363 2.62481 7.06049-2.55938.143-5.26379-.25031-7.74011.47564-2.58716 2.28534 5.68524 1.44281 6.64594 1.60517q10.44635-.00477 20.87884.61621c1.38617.08124 1.38147-2.07532 0-2.15625q-7.43684-.433-14.88843-.51984a11.20866 11.20866 0 0 0 5.74553-6.47386c7.598.17913 15.20959.175 22.79638-.095a5.44261 5.44261 0 0 0 6.66413 6.89863c3.52453-.90174 6.38733-4.41651 7.04114-7.92151 2.91345-.18913 4.90924-2.1074 3.81195-5.06132zm-12.94208-17.12128a8.32563 8.32563 0 0 0 .17377-2.47729 6.04769 6.04769 0 0 1 4.655.98 22.85409 22.85409 0 0 0 2.955 2.42285c1.01843.582 2.06763 1.01208 2.20654 2.31872a15.21393 15.21393 0 0 1 -.01513 2.16706c-3.96255-.17257-10.78066.50634-9.97518-5.41134zm-5.4129 14.11462c.369-4.5924.29339-9.22.633-13.80523.16889-1.86261 1.80994-2.23377 3.385-2.52515-1.77258 5.15387 1.12518 9.25293 6.51856 9.54022 1.60083.1286 3.207-.01953 4.806.152-.02747 2.10736-.35858 4.20069-.39765 6.30646a.86338.86338 0 0 0 .24817.65216c-2.07214-.57617-4.64129-.33765-6.47717-.34351-2.91242-.00921-5.82813.05652-8.74286.12421a.98712.98712 0 0 0 .02695-.10116zm-25.04242 9.6482c-.88709 1.614-2.176 3.3786-4.0047 3.97723-4.2367 1.36426-5.94-3.41553-2.94062-6.04785a8.99472 8.99472 0 0 1 5.5166-1.87781.92571.92571 0 0 0 .51508.34467c.27783.26532.60022.28393.88721.481 1.18475.55043.56555 2.17238.02643 3.12276zm36.25476 0c-.88709 1.614-2.176 3.3786-4.0047 3.97723-4.2367 1.36426-5.94-3.41553-2.94062-6.04785a8.99473 8.99473 0 0 1 5.51661-1.87781.92565.92565 0 0 0 .51507.34467c.27783.26532.60022.28393.88721.481 1.18475.55043.56555 2.17238.02643 3.12276zm3.15075-3.46076c-.45056-1.58148-2.48114-3.20349-4.04089-2.14251a8.54816 8.54816 0 0 0 -8.48956 3.06878c-7.84174.28626-15.69617.18421-23.53791.03681-.022-1.94013-2.29913-4.34034-4.22729-3.10559a8.56359 8.56359 0 0 0 -8.38092 2.92889 6.95144 6.95144 0 0 1 -2.89307-.49469c-2.08685-.96741-1.33832-3.17.38062-4.078a.93728.93728 0 0 0 .97131.685c4.00507-.10247 7.97235-.61126 11.9812-.49176 3.81189.11371 7.6706-.0075 11.48206-.11877 9.37677-.15173 18.82953-.82654 28.16894-.19818 3.90186 1.21502 1.32758 3.55004-1.41449 3.91002z"/><path d="m54.46948 53.7821c-5.52325.096-11.17138-.6795-16.65619.05665a.72045.72045 0 0 0 0 1.3789c5.49335.79907 11.11328.45441 16.65619.71619.76148.01678 1.40821.12561 1.98145-.46784a.83921.83921 0 0 0 0-1.16009c-.54425-.60864-1.2298-.51044-1.98145-.52381z"/><path d="m61.49487 53.52026c-.79254-.14685-1.65033.32325-2.49023.21021a.78131.78131 0 0 0 -.77344.77362c.16565 1.382 2.28058.58874 3.17267.447a.76313.76313 0 0 0 .091-1.43083z"/></g></svg>
            </i>
            <div>
              <h4>Free Shipping</h4>
              <span>Free Shipping on All World. above $250</span>
            </div>
          </div>
        </div>
      </div>
  </div>
</section>
<section class="gap" style="background-image: url(https://via.placeholder.com/1920x904)">
  <div class="container">
    <div class="heading">
      <img alt="heading" src="assets/img/heading.png">
      <h2>Recent Products</h2>
      <p>Love With Our Wide Selection Of Foil Balloons</p>
    </div>
    <div class="product-slider owl-carousel owl-theme">
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <a href="product-details.html">
            <h5>Love Script Silver Baloon</h5>
          </a>
            <h6>$28.61</h6>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <h4>Save 16%</h4>
          <a href="product-details.html">
            <h5>Birthday Party Balloon Decoration</h5>
          </a>
            <div class="d-flex"><h6>$16.69</h6><del>20.20</del></div>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <a href="product-details.html">
            <h5>Party Love Box Balloon</h5>
          </a>
            <h6>$28.61</h6>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <h4>Save 16%</h4>
          <a href="product-details.html">
            <h5>Red Heart Balloon Decoration</h5>
          </a>
            <div class="d-flex"><h6>$16.69</h6><del>20.20</del></div>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <a href="product-details.html">
            <h5>Mattalic Latex Balloons</h5>
          </a>
            <h6>$28.61</h6>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
      <div class="item">
        <div class="product-style">
          <img alt="img" src="https://via.placeholder.com/195x210">
          <a href="product-details.html">
            <h5>Party Love Box Balloon</h5>
          </a>
            <h6>$28.61</h6>
            <span>In stock, 21 units</span>
            <div class="add-to-cart">
              <a href="#" class="btn"><span>Add to Cart</span></a>
              <a href="#" class="heart-wishlist">
                <i class="fa-regular fa-heart"></i>
              </a>
            </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="gap">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-4">
        <div class="holiday">
          <img alt="holiday" src="https://via.placeholder.com/416x264">
          <div class="holiday-text">
            <a href="packages.html"><h3>Valentine's Day</h3></a>
            <span>See Our Selection</span>
          </div>
        </div>
        <div class="holiday mt-4">
          <img alt="holiday" src="https://via.placeholder.com/416x264">
          <div class="holiday-text">
            <a href="packages.html"> <h3>Mothers Day</h3></a>
            <span>See Our Selection</span>
          </div>
        </div>
      </div>
      <div class="col-lg-4">
        <div class="holiday-text-style">
          <h2>Holiday Balloons</h2>
          <p>holiday, and style. Find all your latex, foil, and helium balloons. We can deliver as fast as same day!</p>
          <a href="packages.html" class="btn"><span>Shop Holiday Balloons</span></a>
          <i class="fa-solid fa-location-dot"></i>
          <span>547 S Mason Road, New town Street 2548 United State</span>
        </div>
      </div>
      <div class="col-lg-4">
        <div class="holiday">
          <img alt="holiday" src="https://via.placeholder.com/416x264">
          <div class="holiday-text">
            <a href="packages.html"><h3>Easter Day</h3></a>
            <span>See Our Selection</span>
          </div>
        </div>
        <div class="holiday mt-4">
          <img alt="holiday" src="https://via.placeholder.com/416x264">
          <div class="holiday-text">
            <a href="packages.html"><h3>Colors Day</h3></a>
            <span>See Our Selection</span>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="gap no-top">
  <div class="container">
    <div class="heading two">
      <h2>Party Decorations</h2>
    </div>
    <div class="nav nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
        <button class="nav-link active" id="v-pills-home-tab" data-bs-toggle="pill" data-bs-target="#v-pills-home" type="button" role="tab" aria-controls="v-pills-home" aria-selected="true">Valentine's</button>
        <button class="nav-link" id="v-pills-profile-tab" data-bs-toggle="pill" data-bs-target="#v-pills-profile" type="button" role="tab" aria-controls="v-pills-profile" aria-selected="false">Birthday</button>
        <button class="nav-link" id="v-pills-coffee-tab" data-bs-toggle="pill" data-bs-target="#v-pills-coffee" type="button" role="tab" aria-controls="v-pills-coffee" aria-selected="false">Alphabet</button>
        <button class="nav-link" id="v-pills-pizza-tab" data-bs-toggle="pill" data-bs-target="#v-pills-pizza" type="button" role="tab" aria-controls="v-pills-pizza" aria-selected="false">Cartoon</button>
        <button class="nav-link" id="v-pills-burger-tab" data-bs-toggle="pill" data-bs-target="#v-pills-burger" type="button" role="tab" aria-controls="v-pills-burger" aria-selected="false">Shapes</button>
    </div>
    <div class="tab-content" id="v-pills-tabContent">
                <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="product-details.html">
                            <h5>Love Script Silver Baloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="product-details.html">
                            <h5>Gold Number Ballons</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-lg-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="product-details.html">
                            <h5>Party Balloon Warm Numeral</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="product-details.html">
                            <h5>Giant Number Balloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="v-pills-profile" role="tabpanel" aria-labelledby="v-pills-profile-tab">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Love Script Silver Baloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Gold Number Ballons</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Giant Number Balloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="v-pills-coffee" role="tabpanel" aria-labelledby="v-pills-coffee-tab">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="product-style two mb-lg-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Party Balloon Warm Numeral</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Giant Number Balloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="v-pills-pizza" role="tabpanel" aria-labelledby="v-pills-pizza-tab">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Love Script Silver Baloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Gold Number Ballons</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-lg-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div> 
                        <div>
                          <a href="#">
                            <h5>Party Balloon Warm Numeral</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Giant Number Balloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="v-pills-burger" role="tabpanel" aria-labelledby="v-pills-burger-tab">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Love Script Silver Baloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Gold Number Ballons</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-lg-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Party Balloon Warm Numeral</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="product-style two mb-0">
                        <div>
                          <img alt="img" src="https://via.placeholder.com/140x165">
                        </div>
                        <div>
                          <a href="#">
                            <h5>Giant Number Balloon</h5>
                          </a>
                          <h6>$28.61</h6>
                          <span>In stock, 21 units</span>
                          <div class="add-to-cart">
                            <a href="#" class="btn"><span>Add to Cart</span></a>
                            <a href="#" class="heart-wishlist">
                              <i class="fa-regular fa-heart"></i>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
    </div>
  </div>
</section>
<section class="party-supply" style="background-image: url(https://via.placeholder.com/1920x720);">
  <div class="container">
    <div class="featured-area two">
            <h2>Party Supply and Balloon Recycling</h2>
            <p>Balloons offers one of the largest online balloon selections in the world.</p>
            <a href="#" class="btn two"><span>Recycle Now!</span></a>
          </div>
  </div>
</section>
<section class="gap popular-occasion">
  <div class="container">
    <div class="heading">
      <img alt="heading" src="assets/img/heading.png">
      <h2>Popular Occasion Themes</h2>
      <p>whats trending at bargain balloons themes</p>
    </div>
    <div class="row">
      <div class="col-lg-3">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
          <li class="nav-item tab-style" role="presentation">
            <button class="nav-link active tab-ballon" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Love Theme 
              <i>
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="682.66669" height="682.66669" viewBox="0 0 682.66669 682.66669">
                  <defs id="defs2128">
                    <clipPath clipPathUnits="userSpaceOnUse" id="clipPath2138">
                      <path d="M 0,512 H 512 V 0 H 0 Z" id="path2136"/>
                    </clipPath>
                    <clipPath clipPathUnits="userSpaceOnUse" id="clipPath2150">
                      <path d="M 0,512 H 512 V 0 H 0 Z" id="path2148"/>
                    </clipPath>
                    <clipPath clipPathUnits="userSpaceOnUse" id="clipPath2174">
                      <path d="M 0,512 H 512 V 0 H 0 Z" id="path2172"/>
                    </clipPath>
                  </defs>
                  <mask id="custom"><rect id="bg" x="0" y="0" width="100%" height="100%" fill="white"/><g transform="matrix(1.3333333,0,0,-1.3333333,0,682.66667)"><path transform="matrix(1,0,0,1,228.627,670.4834)" d="m 0,0 17.462,-34.924 c 5.387,-10.773 15.142,-18.712 26.785,-21.798 l 104.15,-27.603 c 26.627,-7.057 52.718,13.02 52.718,40.566 v 92.564 l 60.157,21.523 -52.458,115.904 20.987,32.659 C 218.654,310.637 127.586,389.448 25.943,388.52 c -116.016,-0.024 -209.371,-93.399 -209.37,-209.416 0,-61.115 26.179,-116.115 67.936,-154.398 18.278,-16.759 26.614,-41.77 22.456,-66.218 l -19.048,-111.983 H 93.688 l 8.997,82.951" style="stroke:#000000;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1"/><path transform="matrix(1,0,0,1,402.4873,196.0645)" d="M 0,0 2.292,2.388 2.675,2.157 Z m 90.548,120.45 v 0 c -1.886,1.846 -3.834,3.64 -5.859,5.362 l -0.01,0.011 c 3.461,12.844 5.116,25.249 5.116,37.199 0,74.466 -60.367,134.833 -134.833,134.833 -40.463,0 -76.734,-17.847 -101.449,-46.07 -24.714,28.223 -60.987,46.07 -101.449,46.07 -74.466,0 -134.833,-60.367 -134.833,-134.833 0,-8.58 0.842,-17.391 2.597,-26.432 -23.432,-17.704 -37.43,-46.737 -37.314,-75.478 0,-42.075 22.939,-80.802 59.839,-101.02 l 134.259,-73.565 c 9.512,-17.545 23.695,-32.114 40.979,-42.093 l 32.628,-18.837 c 11.744,-6.781 26.705,-3.684 34.793,7.2 l 30.401,40.916 c 9.525,12.818 5.746,31.076 -8.084,39.06 l -6.279,3.626 1.94,1.59 34.982,28.645 c 16.157,12.297 30.852,24.351 44.158,36.159 l 6.32,5.176 4.154,4.327 c 3.52,3.27 6.938,6.523 10.246,9.755 l 28.372,-17.126 c 40.922,-24.862 93.291,-5.62 93.291,54.73 0,30.511 -12.326,59.6 -33.965,80.795" style="fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none"/><path transform="matrix(1,0,0,1,406.832,199.5674)" d="M 0,0 C -27.567,-27.146 -62.561,-55.655 -106.049,-85.514" style="fill:none;stroke:#000000;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1"/><path transform="matrix(1,0,0,1,87.7617,241.1289)" d="m 0,0 135.382,-82.25 c 0,0 19.619,11.6 43.154,15.539 21.166,3.543 36.946,-19.065 26.216,-37.651 l -7.768,-13.454 25.071,-14.475 c 13.831,-7.985 17.609,-26.242 8.084,-39.061 l -30.402,-40.915 c -8.088,-10.885 -23.049,-13.982 -34.793,-7.201 l -32.628,18.838 c -17.284,9.979 -31.466,24.547 -40.978,42.092 l -134.26,73.565 c -36.899,20.218 -59.839,58.946 -59.839,101.02 -0.115,28.744 13.885,57.779 37.321,75.483 C -57.298,54.059 -33.258,20.046 0,0 Z" style="fill:none;stroke:#000000;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1"/><path transform="matrix(1,0,0,1,487.1768,321.8765)" d="m 0,0 v 0 c 25.265,-21.491 39.823,-52.988 39.823,-86.157 0,-60.35 -52.369,-79.592 -93.291,-54.73 l -193.418,116.751 c -19.95,-0.536 -39.659,4.463 -56.942,14.441 l -32.628,18.838 c -11.744,6.78 -16.543,21.285 -11.16,33.732 l 20.232,46.787 c 6.339,14.658 24.039,20.514 37.869,12.529 l 25.072,-14.475 7.768,13.455 c 10.731,18.585 38.198,16.224 45.714,-3.879 8.357,-22.351 8.119,-45.142 8.119,-45.142 L -18.351,-44.068 C -2.11,-15.011 5.105,12.089 5.105,37.21 c 0,74.466 -60.367,134.833 -134.833,134.833 -40.462,0 -76.734,-17.847 -101.449,-46.07 -24.714,28.223 -60.986,46.07 -101.448,46.07 -74.467,0 -134.833,-60.367 -134.833,-134.833 0,-8.58 0.842,-17.391 2.597,-26.432" style="fill:none;stroke:#000000;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1"/><path transform="matrix(1,0,0,1,228.627,-393.5166)" d="m 0,0 17.462,-34.924 c 5.387,-10.772 15.142,-18.712 26.785,-21.798 l 104.15,-27.602 c 26.627,-7.058 52.718,13.018 52.718,40.565 v 92.564 l 60.157,21.523 -52.458,115.903 20.987,32.66 C 218.654,310.637 127.586,389.448 25.943,388.52 c -116.016,-0.024 -209.371,-93.399 -209.37,-209.416 0,-61.115 26.179,-116.115 67.936,-154.398 18.278,-16.759 26.614,-41.77 22.456,-66.219 l -19.048,-111.982 H 93.688 l 8.997,82.95" style="fill:none;stroke:#000000;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1"/></g></mask><g mask="url(#custom)"><g id="g2130" transform="matrix(1.3333333,0,0,-1.3333333,0,682.66667)">
                    <g>
                      <g clip-path="url(#clipPath2138)">
                        <g transform="translate(228.627,670.4834)">
                          <path d="m 0,0 17.462,-34.924 c 5.387,-10.773 15.142,-18.712 26.785,-21.798 l 104.15,-27.603 c 26.627,-7.057 52.718,13.02 52.718,40.566 v 92.564 l 60.157,21.523 -52.458,115.904 20.987,32.659 C 218.654,310.637 127.586,389.448 25.943,388.52 c -116.016,-0.024 -209.371,-93.399 -209.37,-209.416 0,-61.115 26.179,-116.115 67.936,-154.398 18.278,-16.759 26.614,-41.77 22.456,-66.218 l -19.048,-111.983 H 93.688 l 8.997,82.951" style="fill:none;stroke:#ffffff;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" id="path2142"/>
                        </g>
                      </g>
                    </g>
                    <g id="g2144">
                      <g id="g2146" clip-path="url(#clipPath2150)">
                        <g id="g2152" transform="translate(402.4873,196.0645)">
                          <path d="M 0,0 2.292,2.388 2.675,2.157 Z m 90.548,120.45 v 0 c -1.886,1.846 -3.834,3.64 -5.859,5.362 l -0.01,0.011 c 3.461,12.844 5.116,25.249 5.116,37.199 0,74.466 -60.367,134.833 -134.833,134.833 -40.463,0 -76.734,-17.847 -101.449,-46.07 -24.714,28.223 -60.987,46.07 -101.449,46.07 -74.466,0 -134.833,-60.367 -134.833,-134.833 0,-8.58 0.842,-17.391 2.597,-26.432 -23.432,-17.704 -37.43,-46.737 -37.314,-75.478 0,-42.075 22.939,-80.802 59.839,-101.02 l 134.259,-73.565 c 9.512,-17.545 23.695,-32.114 40.979,-42.093 l 32.628,-18.837 c 11.744,-6.781 26.705,-3.684 34.793,7.2 l 30.401,40.916 c 9.525,12.818 5.746,31.076 -8.084,39.06 l -6.279,3.626 1.94,1.59 34.982,28.645 c 16.157,12.297 30.852,24.351 44.158,36.159 l 6.32,5.176 4.154,4.327 c 3.52,3.27 6.938,6.523 10.246,9.755 l 28.372,-17.126 c 40.922,-24.862 93.291,-5.62 93.291,54.73 0,30.511 -12.326,59.6 -33.965,80.795" style="fill-opacity:1;fill-rule:nonzero;stroke:none" id="path2154"/>
                        </g>
                        <g id="g2156" transform="translate(406.832,199.5674)">
                          <path d="M 0,0 C -27.567,-27.146 -62.561,-55.655 -106.049,-85.514" style="fill:none;stroke:#ffffff;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" id="path2158"/>
                        </g>
                        <g id="g2160" transform="translate(87.7617,241.1289)">
                          <path d="m 0,0 135.382,-82.25 c 0,0 19.619,11.6 43.154,15.539 21.166,3.543 36.946,-19.065 26.216,-37.651 l -7.768,-13.454 25.071,-14.475 c 13.831,-7.985 17.609,-26.242 8.084,-39.061 l -30.402,-40.915 c -8.088,-10.885 -23.049,-13.982 -34.793,-7.201 l -32.628,18.838 c -17.284,9.979 -31.466,24.547 -40.978,42.092 l -134.26,73.565 c -36.899,20.218 -59.839,58.946 -59.839,101.02 -0.115,28.744 13.885,57.779 37.321,75.483 C -57.298,54.059 -33.258,20.046 0,0 Z" style="fill:none;stroke:#ffffff;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" id="path2162"/>
                        </g>
                        <g id="g2164" transform="translate(487.1768,321.8765)">
                          <path d="m 0,0 v 0 c 25.265,-21.491 39.823,-52.988 39.823,-86.157 0,-60.35 -52.369,-79.592 -93.291,-54.73 l -193.418,116.751 c -19.95,-0.536 -39.659,4.463 -56.942,14.441 l -32.628,18.838 c -11.744,6.78 -16.543,21.285 -11.16,33.732 l 20.232,46.787 c 6.339,14.658 24.039,20.514 37.869,12.529 l 25.072,-14.475 7.768,13.455 c 10.731,18.585 38.198,16.224 45.714,-3.879 8.357,-22.351 8.119,-45.142 8.119,-45.142 L -18.351,-44.068 C -2.11,-15.011 5.105,12.089 5.105,37.21 c 0,74.466 -60.367,134.833 -134.833,134.833 -40.462,0 -76.734,-17.847 -101.449,-46.07 -24.714,28.223 -60.986,46.07 -101.448,46.07 -74.467,0 -134.833,-60.367 -134.833,-134.833 0,-8.58 0.842,-17.391 2.597,-26.432" style="fill:none;stroke:#ffffff;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" id="path2166"/>
                        </g>
                      </g>
                    </g>
                    <g id="g2168">
                      <g id="g2170" clip-path="url(#clipPath2174)">
                        <g id="g2176" transform="translate(228.627,-393.5166)">
                          <path d="m 0,0 17.462,-34.924 c 5.387,-10.772 15.142,-18.712 26.785,-21.798 l 104.15,-27.602 c 26.627,-7.058 52.718,13.018 52.718,40.565 v 92.564 l 60.157,21.523 -52.458,115.903 20.987,32.66 C 218.654,310.637 127.586,389.448 25.943,388.52 c -116.016,-0.024 -209.371,-93.399 -209.37,-209.416 0,-61.115 26.179,-116.115 67.936,-154.398 18.278,-16.759 26.614,-41.77 22.456,-66.219 l -19.048,-111.982 H 93.688 l 8.997,82.95" style="fill:none;stroke:#ffffff;stroke-width:30;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" id="path2178"/>
                        </g>
                      </g>
                    </g>
                  </g></g>
                </svg>

              </i>
            </button>
          </li>
          <li class="nav-item tab-style" role="presentation">
            <button class="nav-link tab-ballon" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Birthday Theme
              <i>
                <svg id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path clip-rule="evenodd" d="m468.074 371.602v113.258h-424.148v-113.258c0-4.817 1.958-9.184 5.11-12.336l.03-.03c3.152-3.152 7.519-5.11 12.335-5.11h389.199c4.816 0 9.183 1.959 12.335 5.11l.03.03c3.151 3.151 5.109 7.519 5.109 12.336zm-343.126-119.723c6.283 5.293 10.186 12.681 10.186 20.881v21.422c0 3.655 1.858 7.048 4.849 9.567 3.342 2.815 8.051 4.563 13.315 4.563 5.267 0 9.975-1.748 13.316-4.563 2.99-2.519 4.849-5.913 4.849-9.568v-21.421c0-8.199 3.904-15.587 10.186-20.881 5.933-4.999 14.022-8.103 22.829-8.103 8.806 0 16.896 3.103 22.832 8.103 6.283 5.293 10.186 12.681 10.186 20.881v21.422c0 3.655 1.858 7.048 4.849 9.567 3.341 2.815 8.049 4.563 13.312 4.563 5.268 0 9.977-1.748 13.318-4.563 2.989-2.52 4.849-5.912 4.849-9.567v-21.422c0-8.199 3.903-15.587 10.185-20.881 5.933-4.999 14.023-8.103 22.829-8.103 8.808 0 16.896 3.103 22.831 8.103 6.284 5.293 10.185 12.681 10.185 20.881v21.422c0 3.655 1.858 7.048 4.849 9.567 3.342 2.815 8.051 4.563 13.316 4.563s9.975-1.748 13.316-4.563c2.99-2.52 4.849-5.912 4.849-9.567v-21.422c0-8.197 3.902-15.588 10.186-20.881 5.933-4.999 14.02-8.103 22.829-8.103 5.153 0 10.06 1.062 14.433 2.945-1.391-2.42-3.095-4.641-5.056-6.602-5.667-5.665-13.476-9.182-22.057-9.182h-281.039c-8.581 0-16.39 3.517-22.056 9.182-1.882 1.881-3.525 4.001-4.883 6.304 4.103-1.694 8.697-2.646 13.577-2.646 8.808-.001 16.897 3.103 22.83 8.102zm302.809 20.881h-.392c0-3.656-1.858-7.049-4.849-9.567-3.342-2.815-8.051-4.563-13.316-4.563-5.266 0-9.974 1.749-13.315 4.563-2.991 2.518-4.849 5.913-4.849 9.567v21.422c0 8.199-3.903 15.586-10.186 20.88-5.933 4.999-14.023 8.103-22.829 8.103-8.808 0-16.897-3.103-22.833-8.103-6.283-5.294-10.186-12.681-10.186-20.88v-21.422c0-3.656-1.857-7.049-4.847-9.567-3.342-2.815-8.05-4.563-13.315-4.563s-9.975 1.749-13.316 4.563c-2.991 2.519-4.849 5.913-4.849 9.567v21.422c0 8.199-3.903 15.586-10.186 20.88-5.933 4.999-14.022 8.103-22.83 8.103-8.81 0-16.898-3.103-22.831-8.103-6.284-5.294-10.186-12.681-10.186-20.88v-21.422c0-3.656-1.857-7.049-4.849-9.567-3.342-2.815-8.051-4.563-13.315-4.563-5.266 0-9.974 1.749-13.316 4.563-2.99 2.519-4.849 5.913-4.849 9.567v21.422c0 8.2-3.901 15.587-10.186 20.881-5.933 4.999-14.022 8.102-22.83 8.102-8.806 0-16.896-3.103-22.831-8.103-6.284-5.294-10.186-12.681-10.186-20.88v-21.422c0-3.656-1.857-7.049-4.848-9.567-3.341-2.815-8.05-4.563-13.315-4.563-5.112 0-9.581 1.719-12.747 4.477-2.946 2.567-4.737 6.048-4.737 9.795h-.391v66.373h343.515zm-247.278-132.122c0-3.204-1.299-6.105-3.388-8.194l-.03-.03c-2.088-2.088-4.99-3.387-8.194-3.387h-6.289c-3.92 0-7.49 1.609-10.083 4.201-2.592 2.592-4.201 6.162-4.201 10.082v72.773h32.184v-75.445zm75.521-55.036.421-.476c9.13-10.434 13.659-20.377 13.591-29.825-.069-9.291-4.681-18.62-13.833-27.98l-.179-.181-.178.182c-9.152 9.361-13.765 18.689-13.833 27.98-.069 9.447 4.461 19.39 13.59 29.825zm91.614.001.422-.477c9.129-10.434 13.66-20.377 13.59-29.825-.069-9.291-4.681-18.62-13.833-27.98l-.178-.182-.181.184c-9.151 9.359-13.762 18.687-13.831 27.978-.07 9.446 4.46 19.387 13.588 29.823zm-183.227 0 .424-.479c9.128-10.435 13.658-20.376 13.588-29.823-.069-9.291-4.679-18.62-13.831-27.978l-.181-.184-.181.184c-9.152 9.359-13.763 18.687-13.831 27.978-.07 9.446 4.46 19.387 13.588 29.823zm107.705 55.035c0-3.198-1.303-6.104-3.401-8.209-2.105-2.098-5.011-3.401-8.209-3.401h-6.288c-3.92 0-7.491 1.609-10.084 4.201l-.014-.014c-2.585 2.589-4.187 6.165-4.187 10.096v72.773h32.184v-75.446zm91.613 0c0-3.198-1.303-6.104-3.401-8.209-2.105-2.098-5.011-3.401-8.209-3.401h-6.288c-3.931 0-7.505 1.604-10.096 4.188l.015.014c-2.592 2.592-4.204 6.163-4.204 10.082v72.773h32.184v-75.447z" fill-rule="evenodd"/></svg>
              </i>
            </button>
          </li>
          <li class="nav-item tab-style" role="presentation">
            <button class="nav-link tab-ballon" id="messages-tab" data-bs-toggle="tab" data-bs-target="#messages" type="button" role="tab" aria-controls="messages" aria-selected="false">Gender Reveal<i>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 60 60" width="512" height="512"><g id="Icons"><path d="M42.04,23.47c.02-.13.04-.25.05-.38.04-.55.05-1.09.05-1.63Z"/><path d="M42.32,5.78a1.978,1.978,0,0,1,.02,2.82,2,2,0,0,1-2.84,0c-.33-.331-.4-.45-.67-.45s-.156-.054-2.31,2.1a17.961,17.961,0,0,1-10.49,28.4,12.666,12.666,0,0,1,.53-4.32,14.031,14.031,0,1,0-8.55.18,19.829,19.829,0,0,0-.29,4.05A17.987,17.987,0,1,1,33.78,7.38L35.67,5.5a.5.5,0,0,0,0-.71l-.34-.34a1.979,1.979,0,0,1-.01-2.81,2.039,2.039,0,0,1,2.84-.01c.351.362.427.481.68.5.295,0,.374-.154.77-.55A1.989,1.989,0,0,1,43,2.94a1.923,1.923,0,0,1-.56,1.41l-.45.45a.518.518,0,0,0,.05.71Z"/><path d="M51.53,49.78a18.306,18.306,0,0,1-25.31,1.93l-3.34,3.31h1.14a1.985,1.985,0,0,1,1.39,3.41,1.882,1.882,0,0,1-1.39.57H19.01A3,3,0,0,1,16,56.01V51.02a2.01,2.01,0,0,1,3.45-1.38,1.948,1.948,0,0,1,.56,1.38v1.21l3.43-3.38a17.942,17.942,0,0,1,10.53-28.5,12.167,12.167,0,0,1-.52,4.33A13.885,13.885,0,0,0,24.03,38.5C24.416,50.659,39.3,56.543,47.91,47.87a14.082,14.082,0,0,0-6.01-23.4,16.482,16.482,0,0,0,.23-4.04A17.954,17.954,0,0,1,51.53,49.78Z"/></g></svg>
            </i></button>
          </li>
          <li class="nav-item tab-style" role="presentation">
            <button class="nav-link tab-ballon" id="settings-tab" data-bs-toggle="tab" data-bs-target="#settings" type="button" role="tab" aria-controls="settings" aria-selected="false">Bubble Theme<i>
              <svg height="512" viewBox="0 0 48 48" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Bubbles"><path d="m13 24a11 11 0 1 0 11 11 11 11 0 0 0 -11-11zm8.93 12.12a9 9 0 0 1 -8.93 7.88 1 1 0 0 1 0-2 7 7 0 0 0 7-6.12 1 1 0 0 1 1.93.24z"/><path d="m39 18a7 7 0 1 0 7 7 7 7 0 0 0 -7-7zm5 8a1 1 0 0 1 -1-1 4 4 0 0 0 -4-4 1 1 0 0 1 0-2c5.49 0 7.42 7 5 7z"/><path d="m24 2a5 5 0 1 0 5 5 5 5 0 0 0 -5-5zm0 3a2 2 0 0 0 -2 2 1 1 0 0 1 -1 1c-2.09 0-.82-5 3-5a1 1 0 0 1 0 2z"/><circle cx="8" cy="13" r="3"/></g></svg>
            </i></button>
          </li>
        </ul>
      </div>
      <div class="col-lg-9">
          <div class="tab-content">
            <div class="tab-pane active" id="home" role="tabpanel" aria-labelledby="home-tab">
              <div class="row align-items-center">
                <div class="col-lg-6">
                  <div class="theme-img">
                    <img alt="theme-img" src="https://via.placeholder.com/440x466">
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="theme-text party-balloons">
                    <h6>Ready Time <span>– 2 to 2.5 Hours</span></h6>
                    <h3>love surprise completely elegant theme</h3>
                    <ul>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Ceiling</li>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Floor and Wall</li>
                      <li><img alt="chak" src="assets/img/chak.png">Ravelling Expenses</li>
                    </ul>
                    <div class="d-flex align-items-center justify-content-between">
                      <div class="d-flex align-items-center">
                        <span>Starting From:</span>
                        <h3>$82.61</h3>
                      </div>
                      <div class="star">
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <h6>(12)</h6>
                      </div>
                    </div>
                    <a href="#" class="btn"><span>Book Now</span></a>
                  </div>
                </div>
              </div>
            </div>
            <div class="tab-pane" id="profile" role="tabpanel" aria-labelledby="profile-tab">
              <div class="row align-items-center">
                <div class="col-lg-6">
                  <div class="theme-img">
                    <img alt="theme-img" src="https://via.placeholder.com/440x466">
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="theme-text party-balloons">
                    <h6>Ready Time <span>– 2 to 2.5 Hours</span></h6>
                    <h3>Birthday surprise completely elegant theme</h3>
                    <ul>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Ceiling</li>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Floor and Wall</li>
                      <li><img alt="chak" src="assets/img/chak.png">Ravelling Expenses</li>
                    </ul>
                    <div class="d-flex align-items-center justify-content-between">
                      <div class="d-flex align-items-center">
                        <span>Starting From:</span>
                        <h3>$82.61</h3>
                      </div>
                      <div class="star">
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <h6>(12)</h6>
                      </div>
                    </div>
                    <a href="#" class="btn"><span>Book Now</span></a>
                  </div>
                </div>
              </div>
            </div>
            <div class="tab-pane" id="messages" role="tabpanel" aria-labelledby="messages-tab">
              <div class="row align-items-center">
                <div class="col-lg-6">
                  <div class="theme-img">
                    <img alt="theme-img" src="https://via.placeholder.com/440x466">
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="theme-text party-balloons">
                    <h6>Ready Time <span>– 2 to 2.5 Hours</span></h6>
                    <h3>Gender surprise completely elegant theme</h3>
                    <ul>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Ceiling</li>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Floor and Wall</li>
                      <li><img alt="chak" src="assets/img/chak.png">Ravelling Expenses</li>
                    </ul>
                    <div class="d-flex align-items-center justify-content-between">
                      <div class="d-flex align-items-center">
                        <span>Starting From:</span>
                        <h3>$122.61</h3>
                      </div>
                      <div class="star">
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <h6>(12)</h6>
                      </div>
                    </div>
                    <a href="#" class="btn"><span>Book Now</span></a>
                  </div>
                </div>
              </div>
            </div>
            <div class="tab-pane" id="settings" role="tabpanel" aria-labelledby="settings-tab">
              <div class="row align-items-center">
                <div class="col-lg-6">
                  <div class="theme-img">
                    <img alt="theme-img" src="https://via.placeholder.com/440x466">
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="theme-text party-balloons">
                    <h6>Ready Time <span>– 2 to 2.5 Hours</span></h6>
                    <h3>Bubble surprise completely elegant theme</h3>
                    <ul>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Ceiling</li>
                      <li><img alt="chak" src="assets/img/chak.png">50 Ballons on Floor and Wall</li>
                      <li><img alt="chak" src="assets/img/chak.png">Ravelling Expenses</li>
                    </ul>
                    <div class="d-flex align-items-center justify-content-between">
                      <div class="d-flex align-items-center">
                        <span>Starting From:</span>
                        <h3>$152.61</h3>
                      </div>
                      <div class="star">
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <i class="fa-solid fa-star"></i>
                        <h6>(12)</h6>
                      </div>
                    </div>
                    <a href="#" class="btn"><span>Book Now</span></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
      </div>
    </div>
  </div>
</section>
<section>
  <div class="container">
    <div class="heading">
      <h2>Happy Customer Feedback</h2>
      <p>whats trending at bargain balloons themes</p>
    </div>
    <div class="row feedback-slider owl-carousel owl-theme">
      <div class="col-lg-12 item">
        <div class="customer-feedback">
          <i><img class="quote" alt="quote" src="assets/img/quote.png"></i>
          <p>A huge Thanks Only team to select me for review of product. Its really mean lots to send me products and i like to suggest all to buy them.</p>
          <h4>James Parkar</h4>
          <span>September 11, 2023</span>
          <div class="star">
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
          </div>
        </div>
      </div>
      <div class="col-lg-12 item">
        <div class="customer-feedback">
          <i><img class="quote" alt="quote" src="assets/img/quote.png"></i>
          <p>A huge Thanks Only team to select me for review of product. Its really mean lots to send me products and i like to suggest all to buy them.</p>
          <h4>Thomas Willimes</h4>
          <span>September 11, 2023</span>
          <div class="star">
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
          </div>
        </div>
      </div>
      <div class="col-lg-12 item">
        <div class="customer-feedback">
          <i><img class="quote" alt="quote" src="assets/img/quote.png"></i>
          <p>A huge Thanks Only team to select me for review of product. Its really mean lots to send me products and i like to suggest all to buy them.</p>
          <h4>James Parkar</h4>
          <span>September 11, 2023</span>
          <div class="star">
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
          </div>
        </div>
      </div>
      <div class="col-lg-12 item">
        <div class="customer-feedback">
          <i><img class="quote" alt="quote" src="assets/img/quote.png"></i>
          <p>A huge Thanks Only team to select me for review of product. Its really mean lots to send me products and i like to suggest all to buy them.</p>
          <h4>Nomina Morloo</h4>
          <span>September 11, 2023</span>
          <div class="star">
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
            <i class="fa-solid fa-star"></i>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<div class="gap">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-xl-4">
        <div class="heading two">
          <h2>top brands</h2>
          <p>whats trending at bargain balloons themes</p>
        </div>
      </div>
      <div class="col-xl-8">
        <ul class="top-brands">
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
        </ul>
      </div>
      <div class="col-xl-12">
        <ul class="top-brands mb-0">
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
          <li>
            <img alt="brands-img" src="https://via.placeholder.com/202x130">
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>
<footer class="gap">
    <?php include(TEMPLATE_FRONT . DS . "footer.php");?>  
</footer>
<!-- progress -->
<div id="progress">
      <span id="progress-value"><i class="fa-solid fa-arrow-up"></i></span>
</div>
<!-- jQuery -->
<script src="assets/js/jquery-3.6.0.min.js"></script>
<!-- Bootstrap Js -->
<script src="assets/js/bootstrap.min.js"></script>
<script src="assets/js/owl.carousel.min.js"></script>
<!-- fancybox -->
<script src="assets/js/jquery.fancybox.min.js"></script>
<script src="assets/js/custom.js"></script>
</body>
</html>